﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Text;
using ZSMusic.IDAL;
using ZSMusic.Model;
using ZSMusic.Model.Exceptions;

namespace ZSMusic.BLL
{
    public class MusicHelper
    {
        public static List<Music> Search(string source, string word, int page = 1, int num = 30)
        {

            List<Music> list = new List<Music>();
            if (string.IsNullOrWhiteSpace(word))
            {
                return list;
            }
            IMusic dal = DALFactory.MusicCreator.GetMusic(source);

            if (string.IsNullOrEmpty(word.Trim()))
            { return list; }
            list = word.Contains("@") ?
            SearchCollection(source, word.Substring(1, word.Length - 1))
            : dal.Search(word, page, num);
            return list;
        }

        public static List<Music> SearchCollection(string source, string id)
        {
            IMusic dal = DALFactory.MusicCreator.GetMusic(source);
            return dal.SearchCollection(id);
        }

        public static bool GetData(Music m, string type = "all")
        {
            IMusic dal = DALFactory.MusicCreator.GetMusic(m.Source);
            return dal.GetData(m, type);
        }

        /// <summary>
        /// 重新搜索
        /// </summary>
        /// <param name="s">下架的歌曲</param>
        /// <param name="similar">最低准确率</param>
        /// <returns></returns>
        public static Music ReSearch(Music s, double similar = 0.75, string type = "all")
        {
            if (s == null)
            {
                throw new NullReferenceException();
            }
            if (string.IsNullOrEmpty(s.Name.Trim()))
            {
                throw new ArgumentNullException("曲名");
            }
            if (string.IsNullOrEmpty(s.Artist.Trim()))
            {
                throw new ArgumentNullException("艺术家");
            }
            if (similar == 0)
            {
                similar = 0.75;
            }
            //Assembly ass = Assembly.LoadFrom("ZSMusicDAL.dll");
            //Type t = ass.GetType("ZSMusicDAL.Info");
            string[] source = ZSMusic.DAL.Info.ResearchSource; // t.GetProperty("ResearchSource").GetValue(null, null) as string[];
            List<Music> list = new List<Music>();
            List<Music> result = new List<Music>();
            foreach (string i in source)
            {
                try
                {
                    IMusic dal = DALFactory.MusicCreator.GetMusic(i);
                    list = dal.Search(s.Name, 1, 30);
                    foreach (Music j in list)
                    {
                        string[] filter = new string[] { "live", "现场", "dj", "mix", "翻唱", "原唱", "伴奏", "改编", "cover", "翻自", "声版", "男版", "女版", "混音", "电音" };
                        bool isout = false;
                        string str = (j.ToString() + j.Album).ToLower();
                        foreach (var item in filter)
                        {
                            if (str.Contains(item) && !s.ToString().ToLower().Contains(item))
                            {
                                isout = true;
                                break;
                            }
                        }
                        if (isout)
                        { continue; }


                        double num = j.SimilarWith(s);
                        if (num >= similar)
                        {
                            j.Tag = num;
                            if (dal.GetData(j, type))
                            {
                                if ((double)j.Tag >= 0.99)
                                {
                                    s = j;
                                    return j;
                                }
                                result.Add(j);
                            }
                        }
                    }
                }
                catch (Exception)
                {

                }
            }
            if (result.Count == 0)
            { throw new MusicNotFoundException(string.Format("对不起,未能找到你想要的歌曲资源 {0}", s)); }
            return result.Aggregate((u, v) => (double)u.Tag < (double)v.Tag ? u : v);
        }

        public static Music ReSearch(string artist, string name, double similar = 0.75, string type = "all")
        {
            Music m = new Music();
            m.Artist = artist;
            m.Name = name;
            return ReSearch(m, similar, type);
        }
    }
}
